/*
 * daphne.h
 *
 * Copyright (C) 2001 Matt Ownby
 *
 * This file is part of DAPHNE, a laserdisc arcade game emulator
 *
 * DAPHNE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DAPHNE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// daphne.h

#ifndef DAPHNE_H
#define DAPHNE_H

// global definitions ...

#define LOGNAME "daphne_log.txt"	// name of our logfile if we are using one

#define DAPHNE_VERSION "0.99.6c"

#define LED_RANGE 17 //16 is normal, the 17th is for the 'A' in SAE

enum
{
	GAME_UNDEFINED, GAME_LAIR, GAME_ACE, GAME_CLIFF, GAME_GTG, GAME_SUPERD, GAME_THAYERS, GAME_ASTRON,
	GAME_GALAXY, GAME_ESH, GAME_LAIREURO, GAME_BADLANDS, GAME_STARRIDER, GAME_BEGA, GAME_INTERSTELLAR,
	GAME_SAE
}; // game types
enum { B_DL_PLAYER1, B_DL_PLAYER2, B_DL_LIVES, B_DL_CREDITS, B_DAPHNE_SAVEME, B_GAMENOWOOK, B_OVERLAY_LEDS, B_EMPTY }; // bitmaps
enum { FONT_SMALL, FONT_BIG };	// font enumeration, dependent on which order font .bmp's are loaded in

// dimensions of small font
#define FONT_SMALL_W 6
#define FONT_SMALL_H 13

enum
{
	SWITCH_UP,
	SWITCH_LEFT,
	SWITCH_DOWN,
	SWITCH_RIGHT,
	SWITCH_START1,
	SWITCH_START2,
	SWITCH_BUTTON1,
	SWITCH_BUTTON2,
	SWITCH_BUTTON3,
	SWITCH_COIN1,
	SWITCH_COIN2,
	SWITCH_SKILL1,
	SWITCH_SKILL2, 
	SWITCH_SKILL3,
	SWITCH_SERVICE,
	SWITCH_TEST,
	SWITCH_RESET,
	SWITCH_SCREENSHOT,
	SWITCH_QUIT,
	SWITCH_COUNT
}; // daphne inputs for arcade and additional controls, leave SWITCH_COUNT at the end

enum { MOD_NONE, MOD_SA91, MOD_PAL_DL, MOD_PAL_SA, MOD_PAL_DL_SC, MOD_PAL_SA_SC }; // frame modifiers
//enum { SKILL_CADET, SKILL_CAPTAIN, SKILL_ACE, SKILL_UNSPECIFIED }; // space ace skills
enum { CPU_UNDEFINED, CPU_Z80, CPU_X86, CPU_M6809, CPU_M6502, CPU_COP421, CPU_COUNT };	// cpu's supported by daphne now, leave CPU_COUNT at the end

unsigned char get_filename(char *s, unsigned char n);
void set_quitflag();
unsigned char get_quitflag();
int main(int, char **);
void set_unix_signals();
void handle_unix_signals(int);
void set_serial_port(unsigned char i);
unsigned char get_serial_port();
void set_baud_rate(int i);
int get_baud_rate();
void set_search_offset(int i);
int get_search_offset();
void set_file_mask(char *mask);
char *get_file_mask();
unsigned char get_autostart();
unsigned char get_frame_modifier();
void set_frame_modifier(unsigned char value);
void set_scoreboard(unsigned char value);
unsigned char get_scoreboard();
void set_scoreboard_port(unsigned char value);
unsigned char get_scoreboard_port();
void reset_logfile(int argc, char **argv);
void set_scoreboard_text(char sb_text[]);

void set_idleexit(unsigned int value); // added by JFA for -idleexit
unsigned int get_idleexit(); // added by JFA for -idleexit
// added by JFA for -startsilent
void set_startsilent(unsigned char value);
unsigned char get_startsilent();
// end edit

#endif // DAPHNE_H

