/*
 * dl2.h
 *
 * Copyright (C) 2001 Matt Ownby
 *
 * This file is part of DAPHNE, a laserdisc arcade game emulator
 *
 * DAPHNE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DAPHNE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "game.h"
#include "../io/dll.h"

// functions daphne exports for DL2 to use
struct daphne_exported_api
{
	unsigned char (*get_switch_input)();	// returns daphne input to DL2
	unsigned char (*get_coin_input)();
	void (*play_sound)(int which_sound);	// plays a sound sample
	int (*serial_send_byte)(unsigned char byte);	// sends a byte to the serial port
	int (*serial_byte_available)();	// returns true if there is a byte available to read
	unsigned char (*serial_read_byte)();	// returns a byte from the serial port
	unsigned char (*should_we_quit)();	// returns true if daphne wants to quit
	void (*poll_input)();	// check for new input from daphne
};

// DL2 sounds
enum
{
	S_DL2_WARBLE, S_DL2_ERROR, S_DL2_GOOD, S_DL2_BAD, S_DL2_TIC, S_DL2_TOC, S_DL2_WARN
};

class dl2 : public game
{
public:
	dl2();
	bool init();
	void shutdown();
	void start();
	void input_enable(Uint8);
	void input_disable(Uint8);
private:
	DLL_INSTANCE m_dll_instance;
};

