/*
 * ffr.cpp
 *
 * Copyright (C) 2001 Matt Ownby
 *
 * This file is part of DAPHNE, a laserdisc arcade game emulator
 *
 * DAPHNE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DAPHNE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// ffr.cpp
// by Matt Ownby

// just a little exercise to try to see if I can get a clip from the Freedom Fighter laserdisc
// to play correctly (using skipping)

#include "ffr.h"
#include "../daphne.h"
#include "../ldp-out/ldp.h"

struct clip_boundary
{
	Uint16 start;
	Uint16 end;
};

struct clip_boundary clips[] =
{
	{ 3449, 3546 },
	{ 3557, 3568 },
	{ 3589, 3598 },
	{ 3617, 3626 },
	{ 3665, 3670 },
	{ 3707, 3712 },
	{ 3749, 3756 },
	{ 3797, 3802 },
	{ 3841, 3846 },
	{ 3883, 3890 },
	{ 3929, 3934 },
	{ 3975, 3980 },
	{ 4017, 4024 },
	{ 4063, 4068 },
	{ 4109, 4114 },
	{ 4151, 4158 },
	{ 4197, 4202 },
	{ 4243, 4248 },
	{ 4285, 4292 },
	{ 4331, 4336 },
	{ 4377, 4382 },
	{ 4419, 4426 },
	{ 4465, 4470 },
	{ 4511, 4516 },
	{ 4553, 4560 },
	{ 4599, 4604 },
	{ 4647, 4650 },
	{ 0, 0 }
};

// constructor
ffr::ffr()
{
	m_shortgamename = "ffr";
	m_disc_fps = 29.97;	// Freedom Fighter disc is 29.97 fps
}

//#define SEARCH_METHOD 1

// here's where we do the search loop
void ffr::start()
{
	bool finished = false;
	int index = 0;
	char s[6] = { 0 };	// holds frame
//	int i = 0;
	
	g_ldp->pre_play();	// make sure the disc is playing

#ifdef SEARCH_METHOD	
	while (!finished && !get_quitflag())
	{
		Uint16 start_frame = clips[index].start;
		
		// 0 means we're done
		if (start_frame)
		{
			sprintf(s, "%05d", start_frame);
			g_ldp->pre_search(s);	// do the seek
			g_ldp->pre_play();	// and start playing
			
			// sleep, waiting for frame number to get to last frame of clip
			while (g_ldp->get_current_frame() < clips[index].end - 1)
			{
				SDL_Delay(1);
			}
			
			index++;	// go to the next clip, initiate next search
		}
		else
		{
			finished = true;
		}
	}
#else
	sprintf(s, "%05d", clips[0].start);
	g_ldp->pre_search(s);	// do the seek
	g_ldp->pre_play();	// and start playing

	while (!finished && !get_quitflag())
	{		
		// sleep, waiting for frame number to get to last frame of clip
		while (g_ldp->get_current_frame() < clips[index].end - 1)
		{
			SDL_Delay(0);
		}

		// we're now on the last frame of the sequence

// 3545 to 3557

		// if we have another sequence to skip to, then do so		
		if (clips[index+1].start)
		{
			g_ldp->pre_skip_forward((Uint16) (clips[index+1].start - (clips[index].end - 1)));
		}
		else
		{
			finished = true;
		}

		index++;	// go to the next clip

	}
#endif
}
