/*
 * laireuro.h
 *
 * Copyright (C) 2001 Mark Broadhead
 *
 * This file is part of DAPHNE, a laserdisc arcade game emulator
 *
 * DAPHNE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DAPHNE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LAIREURO_H
#define LAIREURO_H

#include "game.h"

#define LAIREURO_CPU_HZ	3579545	// speed of cpu - from schematics
#define LAIREURO_IRQ_PERIOD (1000.0/60.0)	// Not sure yet....

#define LAIREURO_OVERLAY_W 256	// width of overlay
#define LAIREURO_OVERLAY_H 256 // height of overlay

class laireuro : public game
{
public:
	laireuro();
	void do_irq(unsigned int);
	Uint8 cpu_mem_read(Uint16);
	void cpu_mem_write(Uint16, Uint8);
	Uint8 port_read(Uint16);
	void port_write(Uint16, Uint8);
	void input_enable(Uint8);
	void input_disable(Uint8);
	void palette_calculate();
	void video_repaint();
	
protected:
	Uint8 CTC_register[4];
	Uint8 character[0x2000];	// character rom
	SDL_Color colors[32];				// color palette
	Uint8 banks[4];				// superdon's banks

};

class aceeuro : public laireuro
{
public:
//	bool load_roms();
};

#endif
