/*
 * input.h
 *
 * Copyright (C) 2001 Matt Ownby
 *
 * This file is part of DAPHNE, a laserdisc arcade game emulator
 *
 * DAPHNE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DAPHNE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "SDL.h"

int SDL_input_init();
int SDL_input_shutdown();
void SDL_check_input();
void toggle_console();
void process_event(SDL_Event *event);
void process_keydown(SDLKey key);
void process_keyup(SDLKey key);
void process_joystick_motion(SDL_Event *event);
bool get_consoledown();
void set_consoledown(bool);
void check_console_refresh();
void input_enable(Uint8);
void input_disable(Uint8);
void reset_idle(void); // added by JFA
void set_use_joystick(bool val);

// added by Russ
// global button mapping array. just hardcoded room for 10 buttons max
extern int joystick_buttons_map[10];
