/*
 * ldp1000.h
 *
 * Copyright (C) 2001 Mark Broadhead
 *
 * This file is part of DAPHNE, a laserdisc arcade game emulator
 *
 * DAPHNE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DAPHNE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// LDP1000.H

#ifndef LDP1000_H
#define LDP1000_H

#define LDP1000_SEARCH 0x01
#define LDP1000_REPEAT_NUMBER 0x02
#define LDP1000_REPEAT 0x04

unsigned char read_ldp1000();
void write_ldp1000(unsigned char value);
void ldp1000_enter(void);
bool ldp1000_result_ready(void);
int ldp1000_stack_push(unsigned char value);
void ldp1000_add_digit(char);

#endif
