/*
 * vp931.cpp
 *
 * Copyright (C) 2001 Mark Broadhead
 *
 * This file is part of DAPHNE, a laserdisc arcade game emulator
 *
 * DAPHNE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DAPHNE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// vp931.c
// part of the DAPHNE emulator
// to be written by Mark Broadhead and Warren Ondras :)
//
// This code emulates the Phillips 22VP931 used in Firefox and Freedom Fighter

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../game/game.h"
#include "vp931.h"
#include "../daphne.h"
#include "../io/conout.h"
#include "../video/tms9128nl.h"
#include "../ldp-out/ldp.h"

#define FRAME_SIZE 5

int vp931_output_stack_pointer = 0;

char vp931_frame[FRAME_SIZE+1] = {0}; // holds the digits sent to the VP931
int vp931_frame_index = 0;

bool dav = false; 
bool dak = true; 
bool oprt = false; 

int current_byte = 0;
unsigned char command_byte[3];

// default status
static unsigned char enter_status = 0x00;
///////////////////////////////////////////

// retrieves the status from our virtual VP931
unsigned char read_vp931()
{
	unsigned char result = 0x00;
	printline("VP931 STATUS READ!");
	
	return(result);
}

// sends a byte to our virtual VP931
void write_vp931 (unsigned char value)
{
	char s[81] = { 0 };
	
	// set data full when we receive some data
	dak = false;
	
	// catch the command
	command_byte[current_byte] = value;
	current_byte++;

	// we've got a complete command so process it
	if (current_byte > 2)
	{
		current_byte = 0;

		if (command_byte[0] == 0x00)
		{
			if (command_byte[1] == 0x00)
			{
				g_ldp->pre_play();
			}
			else if (command_byte[1] == 0x10)
			{
				printline("VP931: play reverse received - ignored");
			}
			else if (command_byte[1] == 0x20)
			{
				g_ldp->pre_pause();
			}
			else
			{
				sprintf(s,"Unsupported VP931 Command Received: %x %x %x", command_byte[0], command_byte[1], command_byte[2]);
				printline(s);
			}
		}
		else if (command_byte[0] == 0x02)
		{
			printline("VP931: Audio commands: Implement Me!");
		}
		else if ((command_byte[0] & 0xd0) == 0xd0)
		{
			printline("VP931: Search and Halt command: Implement Me!");
		}
		else if ((command_byte[0] & 0xf0) == 0xf0)
		{
			printline("VP931: Search and Play command: Implement Me!");
		}
		else
		{
			sprintf(s,"Unsupported VP931 Command Received: %x %x %x", command_byte[0], command_byte[1], command_byte[2]);
			printline(s);
		}
	}
}

bool vp931_read_dav()
{
	return(dav);
}

bool vp931_read_dak()
{
	bool result = dak;
	
	// set data empty after one read
	if (!dak)
	{
		dak = true;
	}

	return(result);
}

bool vp931_read_oprt()
{
	return(oprt);
}

void vp931_set_write()
{
	printline("VP931 Write enable set!");
}

void vp931_set_read()
{
	printline("VP931 Read enable set!");
}

void vp931_set_reset()
{
	printline("VP931 RESET!");
	// reset our byte counter
	current_byte = 0;
}

