/*
 * ldp-vldp-legacy.h
 *
 * Copyright (C) 2003 Matt Ownby
 *
 * This file is part of DAPHNE, a laserdisc arcade game emulator
 *
 * DAPHNE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DAPHNE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LDP_VLDP_LEGACY_H
#define LDP_VLDP_LEGACY_H

#include "ldp-vldp.h"

// we inherit from the newer ldp_vldp and override all legacy functions
class ldp_vldp_legacy : public ldp_vldp
{
public:
	ldp_vldp_legacy();
	bool init_player();
	void shutdown_player();
	bool search(char *);
	unsigned int play();
	bool skip_forward(Uint16 frames_to_skip, Uint16 target_frame);
	void pause();
	void request_screenshot();
	void set_search_blanking(bool);
	void set_skip_blanking(bool);
	void set_framefile(char *filename);
	void set_altaudio(char *audio_suffix);
	bool lock_overlay(Uint32);
	bool unlock_overlay(Uint32);
private:
	bool load_vldp_lib();
	void free_vldp_lib();
	bool read_frame_conversions();
	bool first_video_file_exists();
	bool last_video_file_parsed();
	void parse_all_video();
	Uint16 mpeg_info (char *filename, Uint16 ld_frame);
	
	Sint32 m_target_mpegframe;	// mpeg frame # we are seeking to
	Sint32 m_cur_ldframe_offset;	// which laserdisc frame corresponds to the first frame in current mpeg file
	char m_cur_mpeg_filename[160];	// name of the mpeg file we currently have open
	char m_mpeg_path[320]; // location of mpeg file(s) to play
	char m_framefile[160];	// name of the framefile we load to get the names of the mpeg files and their frame #'s
	char m_altaudio_suffix[32]; //adds a suffix to the ogg filename, to support alternate soundtracks
	struct fileframes1 m_mpeginfo[MAX_MPEG_FILES]; // names of mpeg files
	int m_file_index; // # of mpeg files in our list
	DLL_INSTANCE m_dll_instance;	// pointer to DLL we load

	bool m_audio_file_opened;	// whether we have audio to accompany the video
	bool m_blank_on_searches;	// should we blank while searching?
	bool m_blank_on_skips;		// should we blank while skipping?
};

void yuv_callback(SDL_Overlay *dst);

#endif
