/*
 * sound.h
 *
 * Copyright (C) 2001 Matt Ownby
 *
 * This file is part of DAPHNE, a laserdisc arcade game emulator
 *
 * DAPHNE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DAPHNE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SOUND_H
#define SOUND_H

#include <SDL.h>

// header file for sound.c

// max # of samples any game can handle (make this number as small as possible)
#define MAX_NUM_SOUNDS	8

void set_soundbuf_size(Uint16 newbufsize);
bool sound_init();
void sound_shutdown();
bool sound_play(Uint32 whichone);
bool sound_play_saveme();
void sound_volume(Uint8, Uint8);
int load_waves();
void free_waves();
int get_sound_initialized();
void reopen_sound(); // added by JFA for -startsilent
void set_sound_enabled_status (bool value);
bool is_sound_enabled();

#endif
