/*
 * palette.h
 *
 * Copyright (C) 2002 Mark Broadhead
 *
 * This file is part of DAPHNE, a laserdisc arcade game emulator
 *
 * DAPHNE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DAPHNE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

typedef struct
{
	Uint8 y;
	Uint8 v;
	Uint8 u;
	bool transparent;
} t_yuv_color; 

bool palette_initialize (int num_colors);
void palette_set_transparent_color (SDL_Color color_value);
void palette_set_transparent_number(int color_number);
void palette_set_color (int color_num, SDL_Color color_value);
void palette_finalize ();
void palette_shutdown (void);
t_yuv_color *get_yuv_palette(void);

