/*
 * rgb2yuv.cpp
 *
 * Copyright (C) 2001 Matt Ownby
 *
 * This file is part of DAPHNE, a laserdisc arcade game emulator
 *
 * DAPHNE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DAPHNE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// RGB2YUV.CPP
// by Matt Ownby

#include "rgb2yuv.h"

// if we aren't using the assembly version, then use the C version instead
#ifndef MMX_RGB2YUV

unsigned short rgb2yuv_input[3] = { 0 };
unsigned char rgb2yuv_result_y = 0;
unsigned char rgb2yuv_result_u = 0;
unsigned char rgb2yuv_result_v = 0;

#define R rgb2yuv_input[0]
#define G rgb2yuv_input[1]
#define B rgb2yuv_input[2]

// a faster, less accurate version of the RGB->YUV conversion formula
// (faster because no floating point is used)
void rgb2yuv()
{
/*
	y = (unsigned char) (((9798*R)+(19235*G)+(3736*B))/32768);
	u = (unsigned char) ((((-5537*R)+(-10878*G)+(16384*B))/32768) + 128);
	v = (unsigned char) ((((16384*R)+(-13729*G)+(-2664*B))/32768) + 128);
*/

	rgb2yuv_result_y = (unsigned char) (((9798*R) + (19235*G) + (3736*B)) >> 15);
	rgb2yuv_result_u = (unsigned char) ((((B-rgb2yuv_result_y)*18514) >> 15) + 128);
	rgb2yuv_result_v = (unsigned char) ((((R-rgb2yuv_result_y)*23364) >> 15) + 128);
}

#endif
