/*
 * scoreboard.h
 *
 * Copyright (C) 2001 Matt Ownby
 *
 * This file is part of DAPHNE, a laserdisc arcade game emulator
 *
 * DAPHNE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DAPHNE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

int update_player_score(int digit, int value, int player);
int update_player_lives(int value, int player);
int update_credits(int digit, int value);
void set_overlay_scoreboard(bool state);
bool get_overlay_scoreboard();
void draw_overlay_scoreboard(SDL_Surface *overlay, bool show);
void scoreboard_repaint();
bool scoreboard_init();
void scoreboard_shutdown();
int convert_scoreboard(char letter);
void send_scoreboard_text(char sbtext[]);
