/*
 * video.h
 *
 * Copyright (C) 2001 Matt Ownby
 *
 * This file is part of DAPHNE, a laserdisc arcade game emulator
 *
 * DAPHNE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DAPHNE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// by Matt Ownby
// Part of the DAPHNE emulator

#ifndef BITMAP_H
#define BITMAP_H

#include "SDL.h"

#define OVERLAY_LED_WIDTH 8
#define OVERLAY_LED_HEIGHT 13

bool init_display();
void shutdown_display();
void display_repaint();
int load_bmps();
bool draw_led(int, int, int);
void draw_overlay_leds(int led_values[], int num_values, int x, int y, SDL_Surface *overlay);
void draw_othergfx_unsafe(int, int, int);
bool draw_othergfx(int, int, int);
void free_bmps();
SDL_Surface *load_one_bmp(char *);
void free_one_bmp(SDL_Surface *);
void draw_rectangle(short x, short y, unsigned short w, unsigned short h, unsigned char red, unsigned char green, unsigned char blue);
SDL_Surface *get_screen();
int get_console_initialized();
void set_fullscreen(bool value);
Uint16 get_video_width();
void set_video_width(Uint16);
Uint16 get_video_height();
void set_video_height(Uint16);
void take_screenshot(SDL_Overlay *yuvimage);
void save_screenshot(SDL_Surface *shot);
SDL_Color yuv2rgb(unsigned char y, unsigned char u, unsigned char v);
void draw_string(char*, int, int, SDL_Surface*);
void vid_toggle_fullscreen();
#endif
