/*
 * vldp_common.h
 *
 * Copyright (C) 2001 Matt Ownby
 *
 * This file is part of VLDP, a virtual laserdisc player.
 *
 * VLDP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLDP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// shared by the public and private VLDP threads
// nothing else should include this

#ifndef VLDP_COMMON_H
#define VLDP_COMMON_H

#include <SDL.h>
#include <SDL_thread.h>

#include "vldp.h"

#define VLDP_REQ_NONE	0x0
#define VLDP_REQ_OPEN	0x10
#define VLDP_REQ_SEARCH	0x20
#define VLDP_REQ_PLAY	0x30
#define VLDP_REQ_PAUSE	0x40
#define VLDP_REQ_STEP_FORWARD	0x50
#define VLDP_REQ_STOP	0x60
#define VLDP_REQ_STATUS	0x70
#define VLDP_REQ_QUIT	0x80
#define VLDP_REQ_SKIP	0x90

// these are defined to emphasize the importance of the same value being initialized in more than one place
#define CMDORCOUNT_INITIAL 0
#define ACK_COUNT_INITIAL 0

#define STRSIZE 81

extern SDL_mutex *g_vldp_mutex;
extern Uint16 g_req_frame;	// which frame to seek to
extern Uint16 g_ack_frame;	// current actual frame
extern Uint32 g_req_timer;
extern char g_req_file[];	// which file to open
extern int g_blank_during_searches;	// go black when we search?
extern int g_blank_during_skips;	// go black when we skip?
extern Uint8 g_req_cmdORcount;	// the current command count OR'd with the current command of parent thread
								// made 8-bit to ensure that it's atomic
extern unsigned int g_ack_count;	// how many times we've acknowledged a command

extern int g_ack_status;	// the current status of the VLDP (see enums)
extern struct vldp_info g_ack_info;	// contains info about the mpeg file such as its FPS
extern void (*g_yuv_callback)(SDL_Overlay *cur_overlay);

int idle_handler(void *);

// how ms to wait for responses from the private thread before we give up and return an error
#define VLDP_TIMEOUT	5000

#endif
