/*
 * vldp_internal.h
 *
 * Copyright (C) 2001 Matt Ownby
 *
 * This file is part of VLDP, a virtual laserdisc player.
 *
 * VLDP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLDP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// should only be used by the vldp private thread!

#include <SDL.h>

#define DAT_VERSION 2

// header for the .DAT files that are generated
struct dat_header
{
	Uint8 version;	// which version of the DAT file this is
	Uint8 finished;	// whether the parse finished parsing or was interrupted
	Uint8 uses_fields;	// whether the stream uses fields or frames
	Uint32 length;	// length of the m2v stream
};

int idle_handler(void *surface);
void blank_video();
void erase_yuv_overlay(SDL_Overlay *dst);
int ivldp_got_new_command();
void ivldp_ack_command();
void paused_handler();
void play_handler();
void idle_handler_reset();
void ivldp_set_framerate(Uint8 frame_rate_code);
void vldp_process_sequence_header();
void idle_handler_open();
void idle_handler_play();
void ivldp_respond_req_play();
void ivldp_render();
void idle_handler_search(int skip);
int ivldp_get_mpeg_frame_offsets(char *mpeg_name);
int ivldp_parse_mpeg_frame_offsets(char *datafilename, Uint32 mpeg_size, FILE *);
void ivldp_update_progress_indicator(SDL_Surface *indicator, double percentage_completed);

///////////////////////////////////////

extern Uint8 s_old_req_cmdORcount;	// the last value of the command byte we received
extern int s_paused;	// whether the video is to be paused
extern int s_blanked;	// whether the mpeg video is to be blanked
extern int s_frames_to_skip;	// how many frames to skip before rendering the next frame (used for P and B frames seeking)
extern int s_skip_all;	// skip all subsequent frames.  Used to bail out of the middle of libmpeg2, back to vldp
extern int s_step_forward;	// if this is set, we step forward 1 frame
extern Uint32 s_timer;	// FPS timer used by the blitting code to run at the right speed
extern Uint32 s_frames_before_next_frame;	// how many frames should've been rendered (relative to s_timer) before we advance
extern int s_overlay_allocated;	// whether the SDL overlays have been allocated

extern SDL_Overlay *s_hw_overlay;	// if the game uses video overlay, we can't modify our buffers, so we have to
							// copy to the extra overlay and let that get displayed
