// main.h
// by Matt Ownby

#include "wx/wx.h"
#include <wx/dialog.h>
#include <wx/notebook.h>
#include <wx/checkbox.h>
#include <wx/image.h>

#include <string>
#include <queue>

using namespace std;

// structure for holding all variables that we'll be sharing between classes
// I want some classes to have write access to this and others to have read-only access, which is why I've placed it in a struct
struct the_vars
{
	string ldp_driver;	// which laserdisc driver we're using
	int ldp_type_index;	// which item on the combobox we've chosen as our laserdisc player
	string vldp_framefile;	// location of VLDP framefile (if we're using VLDP)
};


class MyCanvas: public wxScrolledWindow
{
public:
    MyCanvas(wxWindow *parent, const wxPoint& pos, const wxSize& size);
	void new_image(const wxString &filename);
	void clear_image();
    void OnPaint(wxPaintEvent& event);
	DECLARE_EVENT_TABLE()
private:
	wxBitmap *m_bitmap;
	wxImage m_image;
};

class MyFrame: public wxFrame
{
public:
    MyFrame(const wxString& title, const wxPoint& pos, const wxSize& size);
    void OnQuit(wxCommandEvent& event);
    void OnAbout(wxCommandEvent& event);
	void OnStart(wxCommandEvent &event);
	void MyFrame::AddCmdLine(string s);
    void OnConfig(wxCommandEvent &event);
	void OnSelected(wxCommandEvent &event);
	void OnNotebook(wxNotebookEvent &event);

	// functions for obtaining various access to our variables ...
	struct the_vars *get_readwrite_vars() { return &m_the_vars; }
	const struct the_vars *get_readonly_vars() { return (const struct the_vars *) &m_the_vars; }

    DECLARE_EVENT_TABLE()

private:
	vector<string> m_cmd_line;
	wxMenu *m_menuFile, *m_menuHelp, *m_menuGame;
	wxMenuBar *m_menuBar;
	wxPanel *m_panel;
	wxListBox *m_listbox;
	wxButton *m_start_button, *m_config_button;
	MyCanvas *m_canvas, *m_daphne_logo;

	wxBoxSizer *m_sizer_main;
	wxBoxSizer *m_sizer_right;
	wxBoxSizer *m_sizer_buttons;

	struct the_vars m_the_vars;	// for sharing various variables that we need to share with other classes
};

class MyConfig: public wxNotebook
{
public:
	MyConfig(wxWindow *parent, wxWindowID id = -1, 
		const wxPoint& pos = wxDefaultPosition,
		const wxSize& size = wxDefaultSize,
		long style = 0);

	~MyConfig();

	void CreateInitialPages();

	void OnPlayerType(wxCommandEvent &event);

	// if they click the 'browse' button
	void OnBrowseFramefile(wxCommandEvent &event);

	// if they change to a new tab ...
	void OnTabChange(wxNotebookEvent &event);

	// converts
	void apply_changes();

	// used to help us calculate the proper size of the notebooksizer
	void display_dynamic_possibility(int which_one);

private:
	wxPanel *CreateGamePage();
	wxPanel *CreateLaserdiscPage();
	wxPanel *CreateVideoPage();
	wxPanel *CreateAudioPage();
	wxPanel *CreateInputPage();
	wxPanel *CreateAdvancedPage();

	void HandlePlayerTypeSelection(const char *player_name);
	void ResetLaserdiscPageLayout();

	const struct the_vars *m_the_vars;

	// Laserdisc Player Tab
	wxComboBox *m_player_type;
	wxStaticBoxSizer *m_vldp_sizer;	// contains vldp-specific options inside, can be hidden when not in use
	wxBoxSizer *m_centering_sizer;

	wxStaticText *m_none_text;
	wxBoxSizer *m_none_sizer;

	wxStaticBox *m_vldp_box;
	wxStaticText *m_vldp_text;
	wxBoxSizer *m_ldp_main_sizer;	// the main LDP sizer ...
	wxTextCtrl *m_vldp_framefile;
	wxButton *m_vldp_browse;
	wxCheckBox *m_vldp_blank_on_skips, *m_vldp_blank_on_searches;

	wxStaticBox *m_ldp_box;
	wxStaticBoxSizer *m_ldp_sizer;
	wxComboBox *m_serial_port;
	wxComboBox *m_baud_rate;

	///////////////////////////////////////////////////////

	// Advanced
	wxComboBox *m_screen_size;
	wxCheckBox *m_disable_sound, *m_disable_hwaccel, *m_sound_buffer_modify, *m_ld_latency_modify;
	wxCheckBox *m_dont_report_stats, *m_disable_crc_check, *m_display_cmd_line;
	wxTextCtrl *m_custom_settings;

	///////////////////////////////////////
	string m_ldp_driver;	// example "vldp"
	string m_ldp_type;	// example "virtual"

	DECLARE_EVENT_TABLE()
};

class MyPreConfig : public wxDialog
{
public:
	MyPreConfig(wxWindow *parent);
    void OnConfigKeys(wxCommandEvent& event);
	void OnConfigButtons(wxCommandEvent& event);
    void OnOK(wxCommandEvent& event);
    void OnCancel(wxCommandEvent& event);
    void OnApply(wxCommandEvent& event);
private:
	MyConfig *m_config;
	wxButton *m_ok, *m_cancel, *m_apply;

	wxBoxSizer *m_sizer_main;
	wxBoxSizer *m_sizer_bottom_row;
	wxNotebookSizer *m_sizer_config;
	
	DECLARE_EVENT_TABLE()
};

class MyApp: public wxApp
{
public:
    virtual bool OnInit();
private:
	MyFrame *m_frame;
};

// handles .INI file
class ini
{
public:
	ini();
	~ini();
	void load_ini();
	bool ini_loaded();
	bool find_key(const char *);
	void go_to_next_line();
	const char *get_right_of_equals();
	const char *get_left_of_equals();
	const char *get_var_value(const char *var);

private:
	void remove_trailing_whitespace(string &s);

	bool m_ini_loaded;
	unsigned char *m_buf;
	unsigned int m_buf_size;
	unsigned int m_buf_index;
};

enum
{
    ID_Quit = 1,
    ID_Error_Log,
	ID_About,
	ID_Web_Site,
	ID_Documentation,
	ID_List_Select,
	ID_Start,
	ID_Watch,
	ID_Config,
	ID_Notebook,
	ID_CFG_KEYS,
	ID_CFG_BUTTONS,
	ID_CFG_OK,
	ID_CFG_CANCEL,
	ID_CFG_APPLY,
	ID_PLAYER_TYPE,
	ID_BROWSE_FRAMEFILE,
};

// macro to safely de-allocate memory
#define DEL(var) if (var) { delete(var); var = NULL; }
